(function (window, undefined) {
  var old_onload = window.onload
  window.onload = function () {
    const template = document.getElementsByClassName('template')[0]
    Vue.prototype.lang = window.lang
    new Vue({
      components: {
        asideMenu,
        topMenu,
      },
      created() {
        this.getCommonData()
        this.getOauthList()
      },
      mounted() {

      },
      updated() {
        // // 关闭loading
        document.getElementById('mainLoading').style.display = 'none';
        document.getElementsByClassName('template')[0].style.display = 'block'
      },
      destroyed() {

      },
      data() {
        return {
          oauthList: [],
        }
      },
      methods: {
        // 返回按钮
        backTicket() {
          location.href = '/account.htm'
        },
        bind(type, name){
          const params = {
            type
          }
          var load = this.$loading()
          bind(params).then(res => {
            load.close();
            window.location.href = res.data.url;
          }, (res) => {
            load.close();
            this.$alert(res.data.msg, '提示', {type: 'error'});
          })
        },
        unbind(type, name){
          this.$confirm('确定解绑'+name+'？', '提示', {type: 'warning'}).then(() => {
            const params = {
              type
            }
            var load = this.$loading()
            unbind(params).then(res => {
              load.close();
              this.$alert('解绑'+name+'成功！', '提示', {type: 'success'}).then(() => {
                window.location.reload();
              })
            }, (res) => {
              load.close();
              this.$alert(res.data.msg, '提示', {type: 'error'});
            })
          })
        },
        // 获取基础信息
        async getOauthList() {
          try {
            const res = await getOauthList()
            this.oauthList = res.data.data
          } catch (error) {
            this.$message(error.data.msg);
          }
        },
        // 获取通用配置
        getCommonData() {
          getCommon().then(res => {
            if (res.data.status === 200) {
              this.commonData = res.data.data
              localStorage.setItem('common_set_before', JSON.stringify(res.data.data))
              document.title = this.commonData.website_name + '-' + '第三方登录'
            }
          })
        }
      },

    }).$mount(template)
    typeof old_onload == 'function' && old_onload()
  };
})(window);
