(function (window, undefined) {
  var old_onload = window.onload
  window.onload = function () {
    const template = document.getElementsByClassName('oauth_login_setting')[0]
    Vue.prototype.lang = window.lang
    new Vue({
      data() {
        return {
          loginType: [
          ],
          formData: {
          },
          loading: false,
          popupProps: {
            overlayStyle: (trigger) => ({ width: `${trigger.offsetWidth}px` }),
          },
        }
      },
      methods: {
        
        async getSetting() {
          try {
            const res = await getRealSetting()
            this.loginType = res.data.data
            this.formData = res.data.conf
          } catch (error) {
            this.$message.error(error.data.msg)
          }
        },
        async onSubmit({ validateResult, firstError }) {
          if (validateResult === true) {
            try {
              this.loading = true
              const res = await saveRealSetting(this.formData)
              this.$message.success(res.data.msg)
              this.getSetting()
              this.loading = false
            } catch (error) {
              this.loading = false
              this.$message.error(error.data.msg)
            }
          } else {
            console.log('Errors: ', validateResult)
            this.$message.warning(firstError)
          }
        }
      },
      created() {
        this.getSetting()
      },
    }).$mount(template)
    typeof old_onload == 'function' && old_onload()
  }
})(window)
