(function (window, undefined) {
  var old_onload = window.onload
  window.onload = function () {
    const template = document.getElementsByClassName('oauth_login_list')[0]
    Vue.prototype.lang = window.lang
    Vue.prototype.moment = window.moment
    const host = location.origin
    const fir = location.pathname.split('/')[1]
    const str = `${host}/${fir}/`
    new Vue({
      data () {
        return {
          data: [],
          tableLayout: true,
          bordered: true,
          visible: false,
          delVisible: false,
          statusVisble: false,
          hover: true,
          virtualScroll: false,
          columns: [
            {
              colKey: 'id',
              title: 'ID',
              width: 60
            },
            {
              colKey: 'client_id',
              title: '用户ID',
              width: 90
            },
            {
              colKey: 'client',
              title: '用户名',
              ellipsis: true,
              width: 200
            },
            {
              colKey: 'typename',
              title: '登录类型',
              width: 100
            },
            {
              colKey: 'openid',
              title: '第三方账号UID',
              width: 320
            },
            {
              colKey: 'nickname',
              title: '第三方账号昵称',
              width: 280
            },
            {
              colKey: 'create_time',
              title: '绑定时间',
              width: 150,
              ellipsis: true
            },
            {
              colKey: 'op',
              title: lang.operation,
              width: 80,
              ellipsis: true
            },
          ],
          hideSortTips: true,
          params: {
            keywords: '',
            type: '',
            page: 1,
            limit: 20,
          },
          loginType: [
          ],
          total: 0,
          pageSizeOptions: [20, 50, 100],
          loading: false,
          delId: '',
          curStatus: 1,
          statusTip: '',
          optType: 'pass',
          curId: '',
          popupProps: {
            overlayStyle: (trigger) => ({ width: `${trigger.offsetWidth}px` })
          },
          maxHeight: '',
        }
      },
      mounted () {
        this.maxHeight = document.getElementById('content').clientHeight - 220
        let timer = null
        window.onresize = () => {
          if (timer) {
            return
          }
          timer = setTimeout(() => {
            this.maxHeight = document.getElementById('content').clientHeight - 220
            clearTimeout(timer)
            timer = null
          }, 300)
        }
      },
      methods: {
        jumpUser (row) {
          location.href = str + `client_detail.htm?client_id=${row.client_id}`
        },
        // 获取列表
        async getList () {
          try {
            this.loading = true
            const res = await getOauthList(this.params)
            this.loading = false
            this.data = res.data.data.list
            this.total = res.data.data.count
          } catch (error) {
            this.loading = false
          }
        },
        // 获取登录方式
        async getLoginType () {
          try {
            const res = await getRealSetting()
            this.loginType = res.data.data
          } catch (error) {
            this.$message.error(error.data.msg)
          }
        },
        // 切换分页
        changePage (e) {
          this.params.page = e.current
          this.params.limit = e.pageSize
          this.getList()
        },
        // 切换状态
        clearKey () {
          this.params.keywords = ''
          this.seacrh()
        },
        seacrh () {
          this.params.page = 1
          this.getList()
        },
        close () {
          this.visible = false
          this.$nextTick(() => {
            this.$refs.userDialog && this.$refs.userDialog.reset()
          })
        },
        // 解除绑定
        unbind (row) {
          this.statusVisble = true
          this.delId = row.client_id
        },
        async sureChange () {
          try {
            var params = {id: this.delId}
            const res = await unbind(params)
            this.$message.success(res.data.msg)
            this.statusVisble = false
            this.getList()
          } catch (error) {
            console.log(error)
            this.$message.error(error.data.msg)
            this.statusVisble = false
          }
        },
        closeDialog () {
          this.statusVisble = false
        },
      },
      created () {
        this.getLoginType()
        this.getList()
      },
    }).$mount(template)
    typeof old_onload == 'function' && old_onload()
  };
})(window);
