(function (window, undefined) {
  var old_onload = window.onload
  window.onload = function () {
    const template = document.getElementsByClassName('oauth_login_interface')[0]
    Vue.prototype.lang = window.lang
    new Vue({
      data() {
        return {
          data: [],
          tableLayout: false,
          bordered: true,
          visible: false,
          delVisible: false,
          statusVisble: false,
          hover: true,
          columns: [
            {
              colKey: 'name',
              title: '接口标识',
              width: 120,
            },
            {
              colKey: 'title',
              title: '接口名称'
            },
            {
              colKey: 'version',
              title: '版本',
              width: 100
            },
            {
              colKey: 'op',
              title: '操作',
              width: 160
            },
          ],
          hideSortTips: true,
          params: {
            keywords: '',
            page: 1,
            limit: 20
          },
          rules: {},
          total: 0,
          pageSizeOptions: [20, 50, 100],
          loading: false,
          upLoading: false,
          country: [],
          delId: '',
          curStatus: 1,
          statusTip: '',
          installTip: '',
          type: '',
          configVisble: false,
          configTip: '',
          configData: [],
          maxHeight: '',
          baseUrl: url,
          upVisible: false,
          curName: '',
          btnLoading:false
        }
      },
      mounted() {
        this.maxHeight = document.getElementById('content').clientHeight - 220
        let timer = null
        window.onresize = () => {
          if (timer) {
            return
          }
          timer = setTimeout(() => {
            this.maxHeight = document.getElementById('content').clientHeight - 220
            clearTimeout(timer)
            timer = null
          }, 300)
        }
      },
      methods: {
        updatePlugin(row) {
          this.upVisible = true
          this.curName = row.name
        },
        // 获取列表
        async getGatewayList() {
          try {
            this.loading = true
            const params = { ...this.params }
            const res = await getMoudle(params)
            this.loading = false
            this.data = res.data.data.list
            this.total = res.data.data.count
          } catch (error) {
            this.loading = false
          }
        },
        async pluginRefresh() {
          this.btnLoading = true;
          try {
            await pluginRefresh()
            this.btnLoading = false
            window.location.reload();
          } catch (error) {
            this.btnLoading = false
            this.$message.error(error.data.msg)
          }
        },
        // 配置
        handleConfig(row) {
          this.configVisble = true
          this.delId = row.name
          this.getConfig(row.id)
        },
        async getConfig(id) {
          try {
            const params = {
              name: this.delId,
              id
            }
            const res = await getMoudleConfig(params)
            this.configData = res.data.data.config
            this.configTip = res.data.data.title
            this.configVisble = true
          } catch (error) {

          }
        },
        // 保存配置
        async onSubmit() {
          try {
            const params = {
              name: this.delId,
              config: {}
            }
            for (const i in this.configData) {
              params.config[this.configData[i].field] = this.configData[i].value
            }
            const res = await saveMoudleConfig(params)
            this.$message.success(res.data.msg)
            this.configVisble = false
            this.getGatewayList()
          } catch (error) {
            this.$message.error(error.data.msg)
          }
        },
        // 切换分页
        changePage(e) {
          this.params.page = e.current
          this.params.limit = e.pageSize
          this.getGatewayList()
        },
        // 排序
        clearKey() {
          this.params.keywords = ''
          this.seacrh()
        },
        seacrh() {
          this.getGatewayList()
        },
        close() {
          this.visible = false
          this.$refs.userDialog.reset()
        },
      },
      created() {
        this.getGatewayList()
      },
      computed: {
        // 格式化配置里面的options
        computedOptions() {
          return (options) => {
            const arr = []
            Object.keys(options).map(item => {
              arr.push({ value: item, label: options[item] })
            })
            return arr
          }
        }
      }
    }).$mount(template)
    typeof old_onload == 'function' && old_onload()
  };
})(window);
