<?php
/**
 * 插件自定义路由,此文档作为范例,注意不要和系统路由产生冲突
 * 说明:官方默认路由需要登录后才能访问,若需要免登录访问,需要自定义路由.
 * 默认路由,后台:/admin/addon?_plugin=demo_style&_controller=admin_index&_action=addhelp;
 * 前台:/console/addon?_plugin=demo_style&_controller=admin_index&_action=addhelp
 * @author wyh
 * @time 2022-06-20
 */
use think\facade\Route;

# 回调接口
Route::get('oauth_login/callback/:type', '\\addon\\oauth_login\\controller\\clientarea\\IndexController@callback')->append(['_plugin' => 'oauth_login', '_controller' => 'index', '_action' => 'callback'])
->middleware(\app\http\middleware\Check::class);

# 登录接口
Route::get('console/v1/oauth_login/login/:type', '\\addon\\oauth_login\\controller\\clientarea\\IndexController@login')->append(['_plugin' => 'oauth_login', '_controller' => 'index', '_action' => 'login'])
->middleware(\app\http\middleware\Check::class);

# 获取配置
Route::get('console/v1/oauth_login/config', '\\addon\\oauth_login\\controller\\clientarea\\IndexController@getConfig')->append(['_plugin' => 'oauth_login', '_controller' => 'index', '_action' => 'get_config'])
->middleware(\app\http\middleware\Check::class);

# 前台
Route::group('console/v1', function () {
    Route::get('oauth_login/oauthList', '\\addon\\oauth_login\\controller\\clientarea\\IndexController@oauthList')->append(['_plugin' => 'oauth_login', '_controller' => 'index', '_action' => 'oauth_list']);
    Route::post('oauth_login/bind', '\\addon\\oauth_login\\controller\\clientarea\\IndexController@bind')->append(['_plugin' => 'oauth_login', '_controller' => 'index', '_action' => 'bind']);
    Route::post('oauth_login/unbind', '\\addon\\oauth_login\\controller\\clientarea\\IndexController@unbind')->append(['_plugin' => 'oauth_login', '_controller' => 'index', '_action' => 'unbind']);
})
->middleware(\app\http\middleware\CheckHome::class)
->middleware(\app\http\middleware\ParamFilter::class);

# 后台
Route::group(DIR_ADMIN . '/v1', function () {
    Route::get('oauth_login/list', '\\addon\\oauth_login\\controller\\AdminIndexController@list')->append(['_plugin' => 'oauth_login', '_controller' => 'admin_index', '_action' => 'list']);
    Route::get('oauth_login/config', '\\addon\\oauth_login\\controller\\AdminIndexController@getConfig')->append(['_plugin' => 'oauth_login', '_controller' => 'admin_index', '_action' => 'get_config']);
    Route::put('oauth_login/config', '\\addon\\oauth_login\\controller\\AdminIndexController@setConfig')->append(['_plugin' => 'oauth_login', '_controller' => 'admin_index', '_action' => 'set_config']);
    Route::get('oauth_login/:id', '\\addon\\oauth_login\\controller\\AdminIndexController@info')->append(['_plugin' => 'oauth_login', '_controller' => 'admin_index', '_action' => 'info']);
    Route::post('oauth_login/unbind', '\\addon\\oauth_login\\controller\\AdminIndexController@unbind')->append(['_plugin' => 'oauth_login', '_controller' => 'admin_index', '_action' => 'unbind']);
    Route::get('oauth_login/plugin', '\\addon\\oauth_login\\controller\\AdminIndexController@pluginList')->append(['_plugin' => 'oauth_login', '_controller' => 'admin_index', '_action' => 'plugin_list']);
    Route::get('oauth_login/plugin/:name', '\\addon\\oauth_login\\controller\\AdminIndexController@pluginInfo')->append(['_plugin' => 'oauth_login', '_controller' => 'admin_index', '_action' => 'plugin_info']);
    Route::put('oauth_login/plugin/:name', '\\addon\\oauth_login\\controller\\AdminIndexController@pluginEdit')->append(['_plugin' => 'oauth_login', '_controller' => 'admin_index', '_action' => 'plugin_edit']);
    Route::get('oauth_login/pluginRefresh', '\\addon\\oauth_login\\controller\\AdminIndexController@pluginRefresh')->append(['_plugin' => 'oauth_login', '_controller' => 'admin_index', '_action' => 'plugin_refresh']);
})
->middleware(\app\http\middleware\CheckAdmin::class)
->middleware(\app\http\middleware\ParamFilter::class);