<?php
namespace addon\oauth_login\plugins\weixin;

class weixin
{

	// 插件基础信息
    public static $info = array(
        'name'        => 'weixin',
        'title'       => '微信登录',
        'version'     => '1.0.0',
		'help_url'    => 'https://open.weixin.qq.com/',
    );

	//生成请求地址
	public function url($params){
        $state = md5(uniqid(rand(), TRUE));
		$_SESSION['Oauth_state']=$state;

		$param = [
			"appid" => $params['appid'],
			"redirect_uri" => $params['callback'],
			"response_type" => "code",
			"scope" => "snsapi_login",
			"state" => $state
		];
		$url =  'https://open.weixin.qq.com/connect/qrconnect?'.http_build_query($param);

        return $url;
	}

	//回调地址
	public function callback($params){
		if(empty($params['code']) || empty($params['state'])){
			throw new \Exception('param error');
		}
		if($_SESSION['Oauth_state']!=$params['state']){
			throw new \Exception('state error');
		}

		list($access_token, $openid) = $this->get_access_token($params);
		$userinfo = $this->get_userinfo($access_token, $openid);
		unset($_SESSION['Oauth_state']);

		return [
			'openid' => $openid,
			'nickname' => $userinfo['nickname'],
			'avatar' => $userinfo['headimgurl'],
		];
	}

	private function get_access_token($params){
		$param = [
			"appid" => $params['appid'],
			"secret" => $params['appkey'],
			"code" => $params['code'],
			"grant_type" => "authorization_code"
		];

		$url = 'https://api.weixin.qq.com/sns/oauth2/access_token?'.http_build_query($param);
		$response = curl($url, null, 10, 'GET');
		$arr = json_decode($response['content'], true);
		if(isset($arr['access_token']) && isset($arr['openid'])){
			return [$arr['access_token'], $arr['openid']];
		}elseif(isset($arr['errcode'])){
			throw new \Exception('获取openid失败 ['.$arr['errcode'].']'.$arr['errmsg']);
		}else{
			throw new \Exception('获取openid失败，原因未知');
		}
	}

	private function get_userinfo($access_token, $openid){
		$param = [
			"access_token" => $access_token,
			"openid" => $openid,
			"lang" => "zh_CN"
		];

		$url = 'https://api.weixin.qq.com/sns/userinfo?'.http_build_query($param);
		$response = curl($url, null, 10, 'GET');
		$arr = json_decode($response['content'], true);
		if(isset($arr['unionid']) || isset($arr['openid'])){
			return $arr;
		}elseif(isset($arr['errcode'])){
			throw new \Exception('获取用户信息失败 ['.$arr['errcode'].']'.$arr['errmsg']);
		}else{
			throw new \Exception('获取用户信息失败，原因未知');
		}
	}
}