<?php
namespace addon\oauth_login\plugins\weibo;

class weibo
{

	// 插件基础信息
    public static $info = array(
        'name'        => 'weibo',
        'title'       => '微博登录',
        'version'     => '1.0.0',
		'help_url'    => 'https://open.weibo.com/',
    );

	//生成请求地址
	public function url($params){
        $state = md5(uniqid(rand(), TRUE));
		$_SESSION['Oauth_state']=$state;

		$param = [
			"response_type" => "code",
			"client_id" => $params['appid'],
			"redirect_uri" => $params['callback'],
			"state" => $state
		];
		$url =  'https://api.weibo.com/oauth2/authorize?'.http_build_query($param);

        return $url;
	}

	//回调地址
	public function callback($params){
		if(empty($params['code']) || empty($params['state'])){
			throw new \Exception('param error');
		}
		if($_SESSION['Oauth_state']!=$params['state']){
			throw new \Exception('state error');
		}

		list($access_token, $uid) = $this->get_access_token($params);
		$userinfo = $this->get_userinfo($access_token, $uid);
		unset($_SESSION['Oauth_state']);

		return [
			'openid' => $uid,
			'nickname' => $userinfo['screen_name'],
			'avatar' => $userinfo['avatar_large'] ? $userinfo['avatar_large'] : $userinfo['profile_image_url'],
		];
	}

	private function get_access_token($params){
		$param = [
			"grant_type" => "authorization_code",
			"code" => $params['code'],
			"client_id" => $params['appid'],
			"client_secret" => $params['appkey'],
			"redirect_uri" => $params['callback'],
		];

		$url = 'https://api.weibo.com/oauth2/access_token';
		$response = curl($url, http_build_query($param));
		$arr = json_decode($response['content'], true);
		if(isset($arr['access_token']) && isset($arr['uid'])){
			return [$arr['access_token'], $arr['uid']];
		}elseif(isset($arr['error'])){
			throw new \Exception('获取access_token失败 '.$arr['error']);
		}else{
			throw new \Exception('获取access_token失败，原因未知');
		}
	}

	private function get_userinfo($access_token, $uid){
		$param = [
			"access_token" => $access_token,
			"uid" => $uid
		];

		$url = 'https://api.weibo.com/2/users/show.json?'.http_build_query($param);
		$response = curl($url, null, 10, 'GET');
		$arr = json_decode($response['content'], true);
		if(isset($arr['screen_name'])){
			return $arr;
		}elseif(isset($arr['error'])){
			throw new \Exception('获取用户信息失败 '.$arr['error']);
		}else{
			throw new \Exception('获取用户信息失败，原因未知');
		}
	}
}