<?php
namespace addon\oauth_login\plugins\qq;

class qq
{

	// 插件基础信息
    public static $info = array(
        'name'        => 'qq',
        'title'       => 'QQ登录',
        'version'     => '1.0.0',
		'help_url'    => 'https://connect.qq.com/',
    );

	//生成请求地址
	public function url($params){
        $state = md5(uniqid(rand(), TRUE));
		$_SESSION['Oauth_state']=$state;

		$param = [
			"response_type" => "code",
			"client_id" => $params['appid'],
			"redirect_uri" => $params['callback'],
			"state" => $state
		];
		$url =  'https://graph.qq.com/oauth2.0/authorize?'.http_build_query($param);

        return $url;
	}

	//回调地址
	public function callback($params){
		if(empty($params['code']) || empty($params['state'])){
			throw new \Exception('param error');
		}
		if($_SESSION['Oauth_state']!=$params['state']){
			throw new \Exception('state error');
		}

		$access_token = $this->get_access_token($params);
		$openid = $this->get_openid($access_token);
		$userinfo = $this->get_userinfo($params['appid'], $access_token, $openid);
		$avatar = $userinfo['figureurl_qq_2']?$userinfo['figureurl_qq_2']:$userinfo['figureurl_qq_1'];
		$avatar = str_replace('http://','https://',$avatar);
		unset($_SESSION['Oauth_state']);

		return [
			'openid' => $openid,
			'nickname' => $userinfo['nickname'],
			'avatar' => $avatar,
		];
	}

	private function get_access_token($params){
		$param = [
			"grant_type" => "authorization_code",
			"client_id" => $params['appid'],
			"redirect_uri" => $params['callback'],
			"client_secret" => $params['appkey'],
			"code" => $params['code']
		];

		$url = 'https://graph.qq.com/oauth2.0/token?'.http_build_query($param);
		$response = curl($url, null, 10, 'GET');
		$response = $response['content'];
		if(strpos($response, "callback") !== false){
			$arr = $this->jsonp_decode($response, true);
		}else{
			parse_str($response, $arr);
		}
		if(isset($arr['access_token'])){
			return $arr['access_token'];
		}elseif(isset($arr['error'])){
			throw new \Exception('获取access_token失败 ['.$arr['error'].']'.$arr['error_description']);
		}else{
			throw new \Exception('获取access_token失败，原因未知');
		}
	}

	private function get_openid($access_token){
		$param = [
			"access_token" => $access_token
		];

		$url = 'https://graph.qq.com/oauth2.0/me?'.http_build_query($param);
		$response = curl($url, null, 10, 'GET');
		$arr = $this->jsonp_decode($response['content'], true);
		if(isset($arr['openid'])){
			return $arr['openid'];
		}elseif(isset($arr['error'])){
			throw new \Exception('获取openid失败 ['.$arr['error'].']'.$arr['error_description']);
		}else{
			throw new \Exception('获取openid失败，原因未知');
		}
	}

	private function get_userinfo($appid, $access_token, $openid){
		$param = [
			"access_token" => $access_token,
			"oauth_consumer_key" => $appid,
			"openid" => $openid
		];

		$url = 'https://graph.qq.com/user/get_user_info?'.http_build_query($param);
		$response = curl($url, null, 10, 'GET');
		$arr = json_decode($response['content'], true);
		if(isset($arr['ret']) && $arr['ret'] == 0){
			return $arr;
		}elseif(isset($arr['msg'])){
			throw new \Exception('获取用户信息失败 ['.$arr['ret'].']'.$arr['msg']);
		}else{
			throw new \Exception('获取用户信息失败，原因未知');
		}
	}

	private function jsonp_decode($jsonp, $assoc = false)
	{
		$jsonp = trim($jsonp);
		if(isset($jsonp[0]) && $jsonp[0] !== '[' && $jsonp[0] !== '{') {
			$begin = strpos($jsonp, '(');
			if(false !== $begin)
			{
				$end = strrpos($jsonp, ')');
				if(false !== $end)
				{
					$jsonp = substr($jsonp, $begin + 1, $end - $begin - 1);
				}
			}
		}
		return json_decode($jsonp, $assoc);
	}
}