<?php
namespace addon\oauth_login\plugins\github;

class github
{

	// 插件基础信息
    public static $info = array(
        'name'        => 'github',
        'title'       => 'GitHub登录',
        'version'     => '1.0.0',
		'help_url'    => 'https://github.com/settings/developers',
    );

	//生成请求地址
	public function url($params){
        $state = md5(uniqid(rand(), TRUE));
		$_SESSION['Oauth_state']=$state;

		$param = [
			"client_id" => $params['appid'],
			"redirect_uri" => $params['callback'],
			"scope" => 'read:user',
			"state" => $state
		];
		$url =  'https://github.com/login/oauth/authorize?'.http_build_query($param);

        return $url;
	}

	//回调地址
	public function callback($params){
		if(empty($params['code']) || empty($params['state'])){
			throw new \Exception('param error');
		}
		if($_SESSION['Oauth_state']!=$params['state']){
			throw new \Exception('state error');
		}

		$access_token = $this->get_access_token($params);
		$userinfo = $this->get_userinfo($access_token);
		unset($_SESSION['Oauth_state']);

		return [
			'openid' => $userinfo['id'],
			'nickname' => $userinfo['name']?$userinfo['name']:$userinfo['login'],
			'avatar' => $userinfo['avatar_url'],
		];
	}

	private function get_access_token($params){
		$param = [
			"code" => $params['code'],
			"client_id" => $params['appid'],
			"client_secret" => $params['appkey'],
			"redirect_uri" => $params['callback'],
		];

		$url = 'https://github.com/login/oauth/access_token?'.http_build_query($param);
		$response = curl($url, null, 10, 'GET');
		parse_str($response['content'], $arr);
		if(isset($arr['access_token'])){
			return $arr['access_token'];
		}elseif(isset($arr['error'])){
			throw new \Exception('获取access_token失败 ['.$arr['error'].']'.$arr['error_description']);
		}else{
			throw new \Exception('获取access_token失败，原因未知');
		}
	}

	private function get_userinfo($access_token){
		$url = 'https://api.github.com/user';
		$response = curl($url, null, 10, 'GET', ['Authorization: token '.$access_token]);
		$arr = json_decode($response['content'], true);
		if(isset($arr['id'])){
			return $arr;
		}elseif(isset($arr['message'])){
			throw new \Exception('获取用户信息失败 '.$arr['message']);
		}else{
			throw new \Exception('获取用户信息失败，原因未知');
		}
	}
}