<?php
namespace addon\oauth_login\plugins\gitee;

class gitee
{

	// 插件基础信息
    public static $info = array(
        'name'        => 'gitee',
        'title'       => 'Gitee登录',
        'version'     => '1.0.0',
		'help_url'    => 'https://gitee.com/oauth/applications',
    );

	//生成请求地址
	public function url($params){
        $state = md5(uniqid(rand(), TRUE));
		$_SESSION['Oauth_state']=$state;

		$param = [
			"response_type" => "code",
			"client_id" => $params['appid'],
			"redirect_uri" => $params['callback'],
			"scope" => 'user_info',
			"state" => $state
		];
		$url =  'https://gitee.com/oauth/authorize?'.http_build_query($param);

        return $url;
	}

	//回调地址
	public function callback($params){
		if(empty($params['code']) || empty($params['state'])){
			throw new \Exception('param error');
		}
		if($_SESSION['Oauth_state']!=$params['state']){
			throw new \Exception('state error');
		}

		$access_token = $this->get_access_token($params);
		$userinfo = $this->get_userinfo($access_token);
		unset($_SESSION['Oauth_state']);

		return [
			'openid' => $userinfo['id'],
			'nickname' => $userinfo['name']?$userinfo['name']:$userinfo['login'],
			'avatar' => $userinfo['avatar_url'],
		];
	}

	private function get_access_token($params){
		$param = [
			"grant_type" => "authorization_code",
			"code" => $params['code'],
			"client_id" => $params['appid'],
			"client_secret" => $params['appkey'],
			"redirect_uri" => $params['callback'],
		];

		$url = 'https://gitee.com/oauth/token';
		$response = curl($url, http_build_query($param));
		$arr = json_decode($response['content'], true);
		if(isset($arr['access_token'])){
			return $arr['access_token'];
		}elseif(isset($arr['error'])){
			throw new \Exception('获取access_token失败 ['.$arr['error'].']'.$arr['error_description']);
		}else{
			throw new \Exception('获取access_token失败，原因未知');
		}
	}

	private function get_userinfo($access_token){
		$param = [
			"access_token" => $access_token
		];
		$url = 'https://gitee.com/api/v5/user?'.http_build_query($param);
		$response = curl($url, null, 10, 'GET');
		$arr = json_decode($response['content'], true);
		if(isset($arr['id'])){
			return $arr;
		}elseif(isset($arr['message'])){
			throw new \Exception('获取用户信息失败 '.$arr['message']);
		}else{
			throw new \Exception('获取用户信息失败，原因未知');
		}
	}
}