<?php
namespace addon\oauth_login\plugins\clogin;

class clogin
{

	// 插件基础信息
    public static $info = array(
        'name'        => 'clogin',
        'title'       => ' 北辰聚合登录',
        'version'     => '1.0.0',
		'help_url'    => '',
    );

	//生成请求地址
	public function url($params){
        //-------生成唯一随机串防CSRF攻击
        $state = md5(uniqid(rand(), TRUE));
		$_SESSION['Oauth_state']=$state;

		$type = $params['type'];
		if($type == 'weixin')$type = 'wx';
		elseif($type == 'weibo')$type = 'sina';
		
        //-------构造请求参数列表
        $keysArr = array(
            "act" => "login",
			"appid" => $params['appid'],
			"appkey" => $params['appkey'],
			"type" => $type,
			"redirect_uri" => $params['callback'],
			"state" => $state
        );
		$login_url = $params['appurl'].'connect.php?'.http_build_query($keysArr);
		$response = curl($login_url, null, 10, 'GET');
		$arr = json_decode($response['content'],true);
		if(isset($arr['code']) && $arr['code']==0){
			return $arr['url'];
		}elseif(isset($arr['msg'])){
			throw new \Exception('获取数据失败：'.$arr['msg']);
		}else{
			throw new \Exception('登录接口返回异常');
		}
	}

	//回调地址
	public function callback($params){
		if(empty($params['code']) || empty($params['state'])){
			throw new \Exception('param error');
		}
		if($_SESSION['Oauth_state']!=$params['state']){
			throw new \Exception('state error');
		}
		//获取 access_token 
        $keysArr = array(
			"act" => "callback",
			"appid" => $params['appid'],
			"appkey" => $params['appkey'],
			"code" => $params['code']
		);
		$token_url = $params['appurl'].'connect.php?'.http_build_query($keysArr);
		$response = curl($token_url, null, 10, 'GET');
		$arr = json_decode($response['content'],true);
		if(isset($arr['code']) && $arr['code']==0){
			unset($_SESSION['Oauth_state']);
			$type = $arr['type'];
			if($type == 'wx')$type = 'weixin';
			elseif($type == 'sina')$type = 'weibo';
			return [
				'type'=>$type,
				'openid'=>$arr['social_uid'],
				'nickname'=>$arr['nickname'],
				'avatar'=>$arr['faceimg'],
			];
		}elseif(isset($arr['msg'])){
			throw new \Exception($arr['msg']);
		}else{
			throw new \Exception('登录接口返回异常');
		}
	}
}