<?php
namespace addon\oauth_login\plugins\baidu;

class baidu
{

	// 插件基础信息
    public static $info = array(
        'name'        => 'baidu',
        'title'       => '百度登录',
        'version'     => '1.0.0',
		'help_url'    => 'https://pan.baidu.com/union/home',
    );

	//生成请求地址
	public function url($params){
        $state = md5(uniqid(rand(), TRUE));
		$_SESSION['Oauth_state']=$state;

		$param = [
			"response_type" => "code",
			"client_id" => $params['appid'],
			"redirect_uri" => $params['callback'],
			"scope" => 'basic',
			"display" => 'page',
			"state" => $state
		];
		$url =  'https://openapi.baidu.com/oauth/2.0/authorize?'.http_build_query($param);

        return $url;
	}

	//回调地址
	public function callback($params){
		if(empty($params['code']) || empty($params['state'])){
			throw new \Exception('param error');
		}
		if($_SESSION['Oauth_state']!=$params['state']){
			throw new \Exception('state error');
		}

		$access_token = $this->get_access_token($params);
		$userinfo = $this->get_userinfo($access_token);
		$avatar = 'https://himg.bdimg.com/sys/portrait/item/'.$userinfo['portrait'].'.jpg';
		unset($_SESSION['Oauth_state']);

		return [
			'openid' => $userinfo['openid'],
			'nickname' => $userinfo['username'],
			'avatar' => $avatar,
		];
	}

	private function get_access_token($params){
		$param = [
			"grant_type" => "authorization_code",
			"code" => $params['code'],
			"client_id" => $params['appid'],
			"client_secret" => $params['appkey'],
			"redirect_uri" => $params['callback'],
		];

		$url = 'https://openapi.baidu.com/oauth/2.0/token?'.http_build_query($param);
		$response = curl($url, null, 10, 'GET');
		$arr = json_decode($response['content'], true);
		if(isset($arr['access_token'])){
			return $arr['access_token'];
		}elseif(isset($arr['error'])){
			throw new \Exception('获取access_token失败 ['.$arr['error'].']'.$arr['error_description']);
		}else{
			throw new \Exception('获取access_token失败，原因未知');
		}
	}

	private function get_userinfo($access_token){
		$param = [
			"access_token" => $access_token
		];

		$url = 'https://openapi.baidu.com/rest/2.0/passport/users/getInfo?'.http_build_query($param);
		$response = curl($url, null, 10, 'GET');
		$arr = json_decode($response['content'], true);
		if(isset($arr['openid'])){
			return $arr;
		}elseif(isset($arr['error_msg'])){
			throw new \Exception('获取用户信息失败 ['.$arr['error_code'].']'.$arr['error_msg']);
		}else{
			throw new \Exception('获取用户信息失败，原因未知');
		}
	}
}