<?php
namespace addon\oauth_login\plugins\alipay;

class alipay
{

	private $config;

	// 插件基础信息
    public static $info = array(
        'name'        => 'alipay',
        'title'       => '支付宝登录',
        'version'     => '1.0.0',
		'help_url'    => 'https://open.alipay.com/',
    );

	//生成请求地址
	public function url($params){
        $state = md5(uniqid(rand(), TRUE));
		$_SESSION['Oauth_state']=$state;

		$param = [
            'app_id' => $params['appid'],
            'scope' => 'auth_user',
            'redirect_uri' => $params['callback'],
			'state' => $state,
        ];
		$url =  'https://openauth.alipay.com/oauth2/publicAppAuthorize.htm?'.http_build_query($param);

        return $url;
	}

	//回调地址
	public function callback($params){
		if(empty($params['auth_code']) || empty($params['state'])){
			throw new \Exception('param error');
		}
		if($_SESSION['Oauth_state']!=$params['state']){
			throw new \Exception('state error');
		}

		$this->setConfig($params);
		$res = $this->get_access_token($params['auth_code']);
		$userinfo = $this->get_userinfo($res['access_token']);
		unset($_SESSION['Oauth_state']);

		return [
			'openid' => $res['user_id'],
			'nickname' => $userinfo['nick_name'],
			'avatar' => $userinfo['avatar'],
		];
	}
	
	private function setConfig($params){
		$this->config = [
			'app_id' => $params['appid'],
			'alipay_public_key' => $params['publickey'],
			'app_private_key' => $params['privatekey'],
		];
	}

	private function get_access_token($code){
		$apiName = 'alipay.system.oauth.token';
		$params = [
			'grant_type' => 'authorization_code',
			'code' => $code
		];
        return $this->aopExecute($apiName, null, $params);
	}

	private function get_userinfo($access_token){
		$apiName = 'alipay.user.info.share';
        $params = [
            'auth_token' => $access_token
        ];
        return $this->aopExecute($apiName, null, $params);
	}

	private function aopExecute($apiName, $bizContent = null, $params = null)
    {
        $request = new Aop\AlipayRequest();
        $request->setApiMethodName($apiName);
        $request->setBizContent($bizContent);
		if (is_array($params) && count($params) > 0) {
            $request->setOtherParams($params);
        }

		$client = new Aop\AopClient();
		$client->appId = $this->config['app_id'];
		$client->rsaPrivateKey = $this->config['app_private_key'];
		$client->rsaPublicKey = $this->config['alipay_public_key'];
        $result = $client->execute($request)->getData();
        if ($apiName == 'alipay.system.oauth.token' && isset($result['access_token'])) {
            return $result;
        } elseif (isset($result['code']) && $result['code'] == '10000') {
            return $result;
        } else {
            throw new Aop\AlipayResponseException($result);
        }
    }
}