<?php
namespace addon\oauth_login\model;

use think\Model;
use addon\oauth_login\OauthLogin;

class OauthLoginPluginModel extends Model
{
    protected $name = 'addon_oauth_login_plugin';

    protected $schema = [
        'name' => 'text',
        'title' => 'text',
        'version' => 'text',
        'help_url' => 'text',
        'config' => 'text',
        'create_time' => 'int',
        'update_time' => 'int'
    ];

    public function List()
    {
        $count = $this->count();
        $list = $this->select()->toArray();
        return ['list' => $list, 'count' => $count];
    }

    public function Info($name)
    {
        $row = $this->where('name', $name)->find();
        if (empty($row)) {
            return (object)[];
        }

        $config_path = WEB_ROOT.'plugins/addon/oauth_login/plugins/'.$name.'/config.php';
        if(!file_exists($config_path)){
            return (object)[];
        }

        $config_item = include $config_path;
        if($row['config']){
            $config = json_decode($row['config'], true);
            foreach($config_item as $key=>$value){
                $config_item[$key]['field'] = $key;
                if(isset($config[$key])){
                    $config_item[$key]['value'] = $config[$key];
                }
            }
        }else{
            foreach($config_item as $key=>$value){
                $config_item[$key]['field'] = $key;
            }
        }
        $row['config'] = array_values($config_item);

        return $row;
    }


    public function getPluginList(){
		$dir = WEB_ROOT.'plugins/addon/oauth_login/plugins/';
		$dirArray[] = NULL;
        if (false != ($handle = opendir($dir))) {
            $i = 0;
            while (false !== ($file = readdir($handle))) {
                if ($file != "." && $file != ".." && strpos($file, ".")===false) {
                    $dirArray[$i] = $file;
                    $i++;
                }
            }
            closedir($handle);
        }
        return $dirArray;
	}

    public function getPluginConfig($name){
        $classname = '\\addon\\oauth_login\\plugins\\'.$name.'\\'.$name;
		if(class_exists($classname) && property_exists($classname, 'info')){
			return $classname::$info;
		}else{
			return false;
		}
	}

    public function refreshPluginList()
    {
        $list = $this->getPluginList();
        foreach($list as $name){
            if ($config = $this->getPluginConfig($name)) {
                $row = $this->where('name', $name)->find();
                if($row){
                    $this->where('name', $name)->update([
                        'title'=>$config['title'],
                        'version'=>$config['version'],
                        'help_url'=>$config['help_url'],
                        'update_time'=>time(),
                    ]);
                }else{
                    $this->insert([
                        'name'=>$config['name'],
                        'title'=>$config['title'],
                        'version'=>$config['version'],
                        'help_url'=>$config['help_url'],
                        'create_time'=>time(),
                        'update_time'=>time(),
                    ]);
                }
            }
        }
    }
}
