<?php
namespace addon\oauth_login\model;

use think\Model;
use addon\oauth_login\OauthLogin;

class OauthLoginModel extends Model
{
    protected $name = 'addon_oauth_login';

    protected $schema = [
        'id' => 'int',
        'client_id' => 'int',
        'type' => 'text',
        'openid' => 'text',
        'nickname' => 'text',
        'avatar' => 'text',
        'create_time' => 'int',
        'update_time' => 'int'
    ];

    public function List($param, $app = '')
    {
        $param['client_id'] = get_client_id();

        $count = $this->alias('aisk')->field('aisk.id')->leftjoin('client c', 'c.id=aisk.client_id')->where(function ($query) use($param, $app) {
            if (!empty($param['keywords'])) {
                $query->where('aisk.client_id|aisk.openid|c.username', $param['keywords']);
            }
            if (!empty($param['type'])) {
                $query->where('aisk.type', $param['type']);
            }
            if ($app == 'home') {
                $query->where('aisk.client_id', $param['client_id']);
            }
        })->count();

        $list = $this->alias('aisk')->field('aisk.id,aisk.client_id,aisk.type,aisk.openid,aisk.nickname,aisk.avatar,aisk.create_time,c.username client')->leftJoin('client c', 'c.id=aisk.client_id')->where(function ($query) use($param, $app) {
            if (!empty($param['keywords'])) {
                $query->where('aisk.client_id|aisk.openid|c.username', $param['keywords']);
            }
            if (!empty($param['type'])) {
                $query->where('aisk.type', $param['type']);
            }
            if ($app == 'home') {
                $query->where('aisk.client_id', $param['client_id']);
            }
        })->limit($param['limit'])->page($param['page'])->order('id', 'DESC')->select()->toArray();

        $loginType = \addon\oauth_login\OauthLogin::$oauth_type;
        foreach ($list as $key => $value) {
            $list[$key]['typename'] = isset($loginType[$value['type']]) ? $loginType[$value['type']] : $value['type'];
            if ($app == 'home') {
                unset($list[$key]['client']);
            }
        }
        return ['list' => $list, 'count' => $count];
    }
    public function Info($id)
    {
        $log = $this->alias('cl')->field('cl.id,c.username,cl.client_id,cl.type,cl.openid,cl.nickname,cl.avatar,cl.create_time,cl.update_time')->leftJoin('client c', 'c.id=cl.client_id')->where('cl.id', $id)->find();
        if (empty($log)) {
            return ['status' => 400, 'msg' => lang_plugins('id_error')];
        }
        $loginType = \addon\oauth_login\OauthLogin::$oauth_type;
        $log['typename'] = isset($loginType[$log['type']]) ? $loginType[$log['type']] : $log['type'];
        $result = ['status' => 200, 'msg' => lang_plugins('success_message'), 'data' => ['log' => $log ?: (object) []]];
        return $result;
    }
}
