<?php
namespace addon\oauth_login\logic;
use app\admin\model\PluginModel;
use addon\oauth_login\model\OauthLoginModel;
use addon\oauth_login\model\OauthLoginPluginModel;

class OauthLogic
{
    private $addonId;

    //获取插件配置
    public function getConfig()
    {
        $PluginModel = new PluginModel();
        $plugin = $PluginModel->where('name','OauthLogin')
            ->where('module','addon')
            ->find();
        if($plugin && $plugin['config']){
            $this->addonId = $plugin['id'];
            return json_decode($plugin['config'], true);
        }else{
            return [];
        }
    }

    //修改插件配置
    public function setConfig($param)
    {
        $old = $this->getConfig();
        $new = $param;
        $isEdit = false;
        foreach ($old as $key => $value) {
            if (isset($new[$key]) && $value != $new[$key]) {
                $isEdit = true;break;
            }
        }

        $PluginModel = new PluginModel();
        $PluginModel->where('name','OauthLogin')
            ->where('module','addon')
            ->update([
                'config' => json_encode($param),
                'update_time' => time()
            ]);

        if($isEdit){
            # 记录日志
            active_log(lang_plugins('oauth_login_update_config', ['{admin}'=>request()->admin_name]), 'admin', request()->admin_id);
        }
        return true;
    }

    private function getPluginConfig($type)
    {
        $config = $this->getConfig();
        if(!isset($config[$type]) || $config[$type] == 0){
            return ['status'=>false, 'msg'=>'未开启该登录类型'];
        }

        if($config[$type] == 2){
            $pluginName = 'clogin';
        }else{
            $pluginName = $type;
        }
        
        $pluginConfig = OauthLoginPluginModel::where('name', $pluginName)->value('config');
        if(empty($pluginConfig)){
            return ['status'=>false, 'msg'=>'登录接口未配置'];
        }
        return ['status'=>true, 'pluginName'=>$pluginName, 'config'=>json_decode($pluginConfig, true)];
    }

    private function getCallbackUrl($type){
        return configuration('website_url') . '/oauth_login/callback/'.$type;
    }

    public function login($type)
    {
        $result = $this->getPluginConfig($type);
        if(!$result['status']) return $result;

        if(!session_id()) session_start();

        $_SESSION['Oauth_userid'] = get_client_id();

        $params = $result['config'];
        $params['type'] = $type;
        $params['callback'] = $this->getCallbackUrl($type);

        $classname = '\\addon\\oauth_login\\plugins\\'.$result['pluginName'].'\\'.$result['pluginName'];
        if(class_exists($classname) && method_exists($classname, 'url')){
            try{
                $oauth = new $classname();
                $url = $oauth->url($params);
                return ['status'=>true, 'url'=>$url];
            }catch(\Exception $e){
                return ['status'=>false, 'msg'=>$e->getMessage()];
            }
        }else{
            return ['status'=>false, 'msg'=>'登录接口不存在'];
        }
    }

    public function callback($type, $params)
    {
        $result = $this->getPluginConfig($type);
        if(!$result['status']) return $result;

        if(!session_id()) session_start();

        $params = array_merge($params, $result['config']);
        $params['callback'] = $this->getCallbackUrl($type);

        $classname = '\\addon\\oauth_login\\plugins\\'.$result['pluginName'].'\\'.$result['pluginName'];
        if(class_exists($classname) && method_exists($classname, 'callback')){
            try{
                $oauth = new $classname();
                $data = $oauth->callback($params);
            }catch(\Exception $e){
                return ['status'=>false, 'msg'=>$e->getMessage()];
            }

            $typename = \addon\oauth_login\OauthLogin::$oauth_type[$type] ?? $type;

            if($_SESSION['Oauth_userid']){ //已登录，执行绑定
                $client_id = $_SESSION['Oauth_userid'];
                $bind_redirect_url = '/plugin/'.$this->addonId.'/oauth.htm';
                $row = OauthLoginModel::where('client_id', $client_id)->where('type', $type)->find();
                if($row){
                    if($row['openid'] == $data['openid']){
                        return ['status'=>true, 'url'=>$bind_redirect_url, 'msg'=>'绑定'.$typename.'成功'];
                    }
                    return ['status'=>false, 'url'=>$bind_redirect_url, 'msg'=>'你已绑定过其他'.$typename.'账号，请勿重复绑定'];
                }else{
                    OauthLoginModel::insert([
                        'client_id' => $client_id,
                        'type' => $type,
                        'openid' => $data['openid'],
                        'nickname' => $data['nickname'],
                        'avatar' => $data['avatar'],
                        'create_time' => time(),
                        'update_time' => time(),
                    ]);
                    return ['status'=>true, 'url'=>$bind_redirect_url, 'msg'=>'绑定'.$typename.'成功'];
                }
            }else{ //未登录，执行登录
                $client_id = OauthLoginModel::where('type', $type)->where('openid', $data['openid'])->value('client_id');
                if(!$client_id){
                    return ['status'=>false, 'msg'=>'此'.$typename.'账号没有被绑定，请先绑定后重试'];
                }
                return $this->loginUser($client_id);
            }
        }else{
            return ['status'=>false, 'msg'=>'登录接口不存在'];
        }
    }

    private function loginUser($client_id){
        $ClientModel = new \app\common\model\ClientModel();
        $client = $ClientModel->where('id', $client_id)->find();
        if(!$client){
            return ['status'=>false, 'msg'=>'用户不存在'];
        }

        # 账号被禁用
        if ($client['status'] != 1){
            active_log(lang('log_client_login_status_disabled',['{client}'=>'client#'.$client->id.'#'.$client->username.'#']),'login',$client->id);
            return ['status'=>false,'msg'=>lang('login_client_is_disabled')];
        }

        try{
            $udpate = [
                'last_login_time' => time(),
                'last_login_ip' => get_client_ip(),
                'last_action_time' => time()
            ];
            $client->save($udpate);

            $ClientLoginModel = new \app\common\model\ClientLoginModel();
            $ClientLoginModel->clientLogin($client->id);
            # 登录提醒
            # 记录日志
            # 赋值,方便记日志
            $request = request();
            $request->client_id = $client->id;
            $request->client_name = $client['username'];
            active_log(lang('log_client_login',['{client}'=>'client#'.$client->id.'#'.$client->username.'#']),'login',$client->id);
			add_task([
				'type' => 'sms',
				'description' => lang('client_phone_password_login_success_send_sms'),
				'task_data' => [
					'name'=>'client_login_success',//发送动作名称
					'client_id'=>$client->id,//客户ID
				],		
			]);	
        }catch (\Exception $e){
            return ['status'=>false, 'msg'=>lang('login_fail') . ':' . $e->getMessage()];
        }

        $info = [
            'id' => $client->id,
            'name' => $client->username,
            'remember_password' => 1
        ];
        $expired = 3600*24*7;

        $jwt = create_jwt($info, $expired);

        return ['status'=>true, 'msg'=>lang('login_success'), 'url'=>'/home.htm', 'jwt'=>$jwt];
    }

}