<?php
namespace addon\oauth_login\controller\clientarea;

use think\facade\View;
use app\event\controller\PluginBaseController;
use addon\oauth_login\model\OauthLoginModel;
use addon\oauth_login\OauthLogin;
use addon\oauth_login\logic\OauthLogic;

class IndexController extends PluginBaseController
{
    public function initialize()
    {
        parent::initialize();
    }

    private function showtips($code, $msg = '', $url = null, $wait = 3, $jwt = null){
        $data = ['code' => $code, 'msg' => $msg, 'url' => $url, 'wait' => $wait, 'jwt' => $jwt];
        View::config(['view_path' => '../public/plugins/addon/oauth_login/template/clientarea/', 'view_suffix' => 'html']);
        return View::fetch('/tips',$data);
    }

    public function getConfig()
    {
        $logic = new OauthLogic();
        $config = $logic->getConfig();

        $list = [];
        foreach(OauthLogin::$oauth_type as $type=>$name){
            if(!isset($config[$type]) || $config[$type] == 0)continue;
            $list[] = ['type'=>$type, 'name'=>$name];
        }
        return json(['status' => 200, 'msg' => lang('success_message'), 'data' => $list]);
    }

    public function login()
    {
        $param = $this->request->param();
        $type = $param['type'];
        if(!array_key_exists($type, OauthLogin::$oauth_type)) {
            return json(['status' => 400, 'msg' => '不存在的登录类型']);
        }

        $logic = new OauthLogic();
        $result = $logic->login($type);
        if ($result['status']) {
            return json(['status' => 200, 'msg' => lang('success_message'), 'url' => $result['url']]);
        }else{
            return json(['status' => 400, 'msg' => $result['msg']]);
        }
    }

    public function callback()
    {
        $param = $this->request->param();
        $type = $param['type'];
        if(!array_key_exists($type, OauthLogin::$oauth_type)) {
            return $this->showtips('error', '不存在的登录类型', '/login.htm');
        }

        $logic = new OauthLogic();
        $result = $logic->callback($type, $param);
        if ($result['status']) {
            if(isset($result['jwt'])){
                return $this->showtips('success', $result['msg'], $result['url'], 3, $result['jwt']);
            }
            return $this->showtips('success', $result['msg'], $result['url']);
        }else{
            return $this->showtips('error', $result['msg'], isset($result['url'])?$result['url']:'/login.htm', 0);
        }
    }

    public function bind()
    {
        $type = input('post.type');
        if(!array_key_exists($type, OauthLogin::$oauth_type)) {
            return json(['status' => 400, 'msg' => '不存在的登录类型']);
        }
        
        $count = OauthLoginModel::where(['client_id' => get_client_id(), 'type' => $type])->count();
        if ($count > 0) {
            return json(['status' => 400, 'msg' => '你已绑定'.OauthLogin::$oauth_type[$type].'，请勿重复绑定']);
        }

        $logic = new OauthLogic();
        $result = $logic->login($type);
        if ($result['status']) {
            return json(['status' => 200, 'msg' => lang('success_message'), 'url' => $result['url']]);
        }else{
            return json(['status' => 400, 'msg' => $result['msg']]);
        }
    }

    public function unbind()
    {
        $type = input('post.type');
        if(!array_key_exists($type, OauthLogin::$oauth_type)) {
            return json(['status' => 400, 'msg' => '不存在的登录类型']);
        }

        $row = OauthLoginModel::where(['client_id' => get_client_id(), 'type' => $type])->find();
        if ($row) {
            OauthLoginModel::where('id', $row['id'])->delete();
            return json(['status' => 200, 'msg' => '成功解绑'.OauthLogin::$oauth_type[$type]]);
        } else {
            return json(['status' => 400, 'msg' => '你已解绑'.OauthLogin::$oauth_type[$type]]);
        }
    }

    public function oauthList()
    {
        $client_id = get_client_id();
        $loginList = OauthLoginModel::where('client_id', $client_id)->column('*','type');

        $logic = new OauthLogic();
        $config = $logic->getConfig();

        $list = [];
        foreach(OauthLogin::$oauth_type as $type=>$name){
            if(!isset($config[$type]) || $config[$type] == 0)continue;
            $user = ['state'=>false];
            if(isset($loginList[$type])){
                $user = ['state'=>true,'openid'=>$loginList[$type]['openid'],'nickname'=>$loginList[$type]['nickname'],'avatar'=>$loginList[$type]['avatar']];
            }
            $list[] = ['type'=>$type, 'name'=>$name, 'user'=>$user];
        }
        return json(['status' => 200, 'msg' => lang('success_message'), 'data' => $list]);
    }
}

?>