<?php
namespace addon\oauth_login\controller;

use addon\oauth_login\logic\OauthLogic;
use addon\oauth_login\model\OauthLoginModel;
use addon\oauth_login\model\OauthLoginPluginModel;

class AdminIndexController extends \app\event\controller\PluginAdminBaseController
{
    public function initialize()
    {
        parent::initialize();
    }

    public function getConfig()
    {
        $loginType = \addon\oauth_login\OauthLogin::$oauth_type;
        $logic = new OauthLogic();
        $config = $logic->getConfig();
        $list = [];
        $conf = [];
        foreach($loginType as $name=>$title){
            $value = isset($config[$name])?$config[$name]:0;
            $list[] = ['name'=>$name, 'title'=>$title, 'value'=>$value];
            $conf[$name] = $value;
        }
        return json(["status" => 200, "msg" => lang_plugins("success_message"), "data" => $list, "conf" => $conf]);
    }

    public function setConfig()
    {
        $param = $this->request->param();
        $logic = new OauthLogic();
        $logic->setConfig($param);
        return json(["status" => 200, "msg" => lang_plugins("update_success")]);
    }

    public function list()
    {
        $param = array_merge($this->request->param(), ["page" => $this->request->page, "limit" => $this->request->limit]);
        $oauthLoginModel = new OauthLoginModel();
        $data = $oauthLoginModel->List($param);
        $result = ["status" => 200, "msg" => lang_plugins("success_message"), "data" => $data];
        return json($result);
    }

    public function info()
    {
        $id = input('param.id/d');
        $oauthLoginModel = new OauthLoginModel();
        $result = $oauthLoginModel->Info($id);
        return json($result);
    }

    public function unbind()
    {
        $id = input('post.id/d');
        OauthLoginModel::where(["id" => $id])->delete();
        return json(["status" => 200, "msg" => "解绑成功"]);
    }

    public function pluginList()
    {
        $oauthLoginPluginModel = new OauthLoginPluginModel();
        $data = $oauthLoginPluginModel->List();
        if($data['count'] == 0){
            $oauthLoginPluginModel->refreshPluginList();
        }
        $data = $oauthLoginPluginModel->List();
        $result = ["status" => 200, "msg" => lang_plugins("success_message"), "data" => $data];
        return json($result);
    }

    public function pluginInfo()
    {
        $name = input('param.name');
        $oauthLoginPluginModel = new OauthLoginPluginModel();
        $data = $oauthLoginPluginModel->Info($name);
        $result = ["status" => 200, "msg" => lang_plugins("success_message"), "data" => $data];
        return json($result);
    }

    public function pluginEdit()
    {
        $name = input('param.name');
        $config = input('put.config');
        if(empty($config)){
            return json(["status" => 400, "msg" => "参数不能为空"]);
        }
        $oauthLoginPluginModel = new OauthLoginPluginModel();
        $oauthLoginPluginModel->where('name', $name)->update([
            'config' => json_encode($config),
            'update_time' => time()
        ]);
        $result = ["status" => 200, "msg" => lang_plugins("update_success")];
        return json($result);
    }

    public function pluginRefresh()
    {
        $oauthLoginPluginModel = new OauthLoginPluginModel();
        $oauthLoginPluginModel->refreshPluginList();
        $result = ["status" => 200, "msg" => '刷新插件列表成功'];
        return json($result);
    }
}

?>