<?php
/*
 * @ 第三方登录插件
 * @ Author: 消失的彩虹海
 * @ Version: 1.0.0
 */

namespace addon\oauth_login;

use app\common\lib\Plugin;
use think\facade\Db;

/*
 * 第三方登录
 * @time 2023-10-30
 */
class OauthLogin extends Plugin
{
    # 插件基本信息
    public $info = [
        'name' => 'OauthLogin',
        'title' => '第三方登录',
        'description' => '支持多种登录方式的第三方登录插件',
        'author' => 'https://u.beichenwl.cn/',
        'version' => '1.0.0'
    ];

    public static $oauth_type = [
        'qq' => 'QQ登录',
        'weixin' => '微信登录',
        'weibo' => '微博登录',
        'baidu' => '百度登录',
        'alipay' => '支付宝登录',
        'github' => 'GitHub登录',
        'gitee' => 'Gitee登录',
    ];

    # 插件安装
    public function install()
    {
        $sql = [
            "CREATE TABLE IF NOT EXISTS  `idcsmart_addon_oauth_login` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `client_id` int(11) NOT NULL DEFAULT '0' COMMENT '用户ID',
  `type` varchar(20) NOT NULL COMMENT '登录类型',
  `openid` varchar(100) NOT NULL DEFAULT '' COMMENT '第三方登录ID',
  `nickname` varchar(150) NOT NULL DEFAULT '' COMMENT '昵称',
  `avatar` varchar(250) DEFAULT NULL COMMENT '头像地址',
  `create_time` int(11) NOT NULL DEFAULT '0' COMMENT '创建时间',
  `update_time` int(11) NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `client_id` (`client_id`),
  KEY `openid` (`openid`, `type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='第三方登录绑定明细'",
            "CREATE TABLE IF NOT EXISTS  `idcsmart_addon_oauth_login_plugin` (
  `name` varchar(20) NOT NULL COMMENT '插件标识',
  `title` varchar(50) NOT NULL COMMENT '插件名称',
  `version` varchar(20) DEFAULT NULL COMMENT '版本号',
  `help_url` varchar(300) DEFAULT NULL COMMENT '申请地址',
  `config` text DEFAULT NULL COMMENT '插件配置',
  `create_time` int(11) NOT NULL DEFAULT '0' COMMENT '创建时间',
  `update_time` int(11) NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='第三方登录插件'",
        ];
        foreach ($sql as $v) {
            \think\facade\Db::execute($v);
        }

        $src_path = WEB_ROOT.'plugins/addon/oauth_login/template/clientarea/login.html';
        $dest_path = WEB_ROOT.'clientarea/template/default/login.php';
        copy($src_path, $dest_path);
        $this->cleanTempDir();
        
        return true;
    }
    # 插件卸载
    public function uninstall()
    {
        $sql = [
            "DROP TABLE IF EXISTS `idcsmart_addon_oauth_login`",
            "DROP TABLE IF EXISTS `idcsmart_addon_oauth_login_plugin`"
        ];
        foreach ($sql as $v) {
            \think\facade\Db::execute($v);
        }
        return true;
    }

    # 清理模板临时文件
    private function cleanTempDir(){
        $path = app()->getRuntimePath().'temp';
        if (is_dir($path)) {
            $dirs = scandir($path);
            foreach ($dirs as $dir) {
                if ($dir != '.' && $dir != '..') {
                    @unlink($path.'/'.$dir);
                }
            }
        }
    }
}
